/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Form fields controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

CommonForm.elementControllers.push(
  {
    pattern: '.inline-field.inline-color',
    handler: function ()
    {
      var obj = this;
      var field = jQuery(this);
      var line = field.parents('.line').eq(0);
      var row = line.get(0);
      var inp = jQuery('input.color', this);

      // Check - process blur event or not
      this.isProcessBlur = function()
      {
        return false;
      };

      // Save field into view
      this.saveField = function()
      {
        if (this.getFieldFormattedValue()) {
          field.find(this.viewValuePattern).find('.value').css('background-color', '#' + this.getFieldFormattedValue());

        } else {
          field.find(this.viewValuePattern).find('.value').css('background-color', 'transparent');
        }
      };

      this.forceSaveField = function()
      {
        obj.sanitize();
        result = !inp.validationEngine('validate');

        if (result && row) {
          row.inlineGroupBlurTimeout = setTimeout(
            function () {
              row.inlineGroupBlurTimeout = false;
              row.saveFields();
            },
            100
          );
        }

        obj.endEdit();
      };

      inp.bind(
        'colorhide',
        _.bind(
          function() {
            setTimeout(
              function()
              {
                inp.focus();
              },
              200
            );
          },
          this
        )
      );
      inp.bind(
        'colorchange',
        _.bind(
          function() {
            inp.focus();
            inp.change();
          },
          this
        )
      );

      inp.blur(
        _.bind(
          function(event) {
            obj.blurTimeout = setTimeout(
              _.bind(this.forceSaveField, this),
              500
            );
          },
          this
        )
      );

      jQuery(this).find('.color-box')
        .unbind('click')
        .click(
          _.bind(
            function(event) {
              if (obj.blurTimeout) {
                clearTimeout(obj.blurTimeout);
                obj.blurTimeout = null;
              }
              inp.click();
              event.stopPropagation();
            },
            this
          )
        );
      inp.bind(
        'colorshow',
        _.bind(
          function() {
            jQuery('.colorpicker').bind(
              'click mousemove',
              function() {
                if (obj.blurTimeout) {
                  clearTimeout(obj.blurTimeout);
                  obj.blurTimeout = null;
                }
              }
            );
          },
          this
        )
      );

      field.bind(
        'startEditInline',
        function() {
          inp.click();
        }
      );
    }
  }
);
