/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Color swatches controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

function ColorSwatchesController(elm)
{
  Base.apply(this);
  this.line = jQuery(elm);
  this.colorSwatchesModeValue = 'C';
  this.initialize();
}

extend(ColorSwatchesController, Base);

ColorSwatchesController.prototype.line = null;

ColorSwatchesController.prototype.isColorSwatchesModeEnabled = function()
{
  return this.line.find("input.display-mode-input:checked").val() === this.colorSwatchesModeValue
    && this.line.find(".swatch-selector").length > 0;
};

ColorSwatchesController.prototype.initialize = function()
{
  this.switchSwatches(this.isColorSwatchesModeEnabled());
  var self = this;
  this.line.find(".display-mode-variant input[type=radio]").on("change", function() {
    self.switchSwatches(self.isColorSwatchesModeEnabled());
  });
  xcart.bind('colorswatches.swatch.change', _.bind(this.handleSwatchChange, this));
};

ColorSwatchesController.prototype.getValues = function()
{
  return this.line.find('.value > .table-value[class*="attributevalue-"] input');
};

ColorSwatchesController.prototype.getSwatchSelectors = function()
{
  return this.line.find('.swatch-selector select');
};

ColorSwatchesController.prototype.hide = function()
{
  this.switchSwatches(false);
  this.line.removeClass('allow-swatches');
};

ColorSwatchesController.prototype.show = function()
{
  this.line.addClass('allow-swatches');
  this.switchSwatches(this.isColorSwatchesModeEnabled());
};

ColorSwatchesController.prototype.switchSwatches = function(visible)
{
  if (visible) {
    this.showSwatches();
  } else {
    this.hideSwatches();
  }
};

ColorSwatchesController.prototype.showSwatches = function()
{
  this.line.addClass('has-swatches');
};

ColorSwatchesController.prototype.hideSwatches = function()
{
  this.line.removeClass('has-swatches');
};

ColorSwatchesController.prototype.handleSwatchChange = function(event, data)
{
};

/** Element controllers */
CommonForm.elementControllers.push(
  {
    pattern: '.type-s .multiple-checkbox input',
    handler: function ()
    {
      jQuery(this).change(
        function(event) {
          xcart.trigger('colorswatches.multiselect.change', { target: event.target });
        }
      );
    }
  }
);

CommonForm.elementControllers.push(
  {
    pattern: '.swatch-selector select',
    handler: function ()
    {
      jQuery(this).change(
        function(event) {
          xcart.trigger('colorswatches.swatch.change', { target: event.target });
        }
      );
    }
  }
);

CommonForm.elementControllers.push(
  {
    pattern: '.attributes .lines li.line, .attribute-group .lines li.line',
    handler: function ()
    {
      new ColorSwatchesController(this);
    }
  }
);
