/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Color swatches controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

function ColorSwatchesController(elm)
{
  Base.apply(this);

  this.box = jQuery(elm);

  this.initialize();
}

extend(ColorSwatchesController, Base);

ColorSwatchesController.prototype.box = null;

ColorSwatchesController.prototype.initialize = function()
{
  this.box.find('li a').click(_.bind(this.handleSwatchClick, this));
  this.box.find('li a').popover();
  this.box.find('li a').each(
    function() {
      this.title = jQuery(this).data('name');
    }
  );
};

ColorSwatchesController.prototype.handleSwatchClick = function(event)
{
  var elm = jQuery(event.currentTarget).parent();
  var list = elm.parents('.color-swatches');
  var ctrl, pid;
  var box = jQuery('div.product-details');

  list.find('input').prop('checked', false);
  elm.find('input')
    .prop('checked', true)
    .change();

  list.children().removeClass('selected');
  elm.addClass('selected');

  if (box.length) {
    ctrl = box.get(0).controller;
    pid  = box.find('input[name="product_id"]').val();
    if (ctrl && typeof(ctrl.block) != 'undefined' && typeof(ctrl.block.loadVariantsImages) != 'undefined' && pid) {
      ctrl.block.loadVariantsImages(pid);
    }
  }

  return false;
};

ColorSwatchesController.prototype.getEventNamespace = function()
{
  return 'colorswatches.selector';
};

CommonForm.elementControllers.push(
  {
    pattern: '.color-swatches',
    handler: function ()
    {
      new ColorSwatchesController(this);
    }
  }
);

(function()
{
  xcart.registerWidgetsParamsGetter(
    'update-product-page',
    function(product)
    {
      var result = getAttributeValuesParams(product);
      var base = '.product-info-' + product.product_id;

      jQuery("ul.attribute-values input[type=radio]:checked", jQuery(base).last()).each(function (index, elem)
      {
        result.attribute_values += jQuery(elem).data('attribute-id') + '_' + jQuery(elem).val() + ',';
      });

      return result;
    }
  );

  xcart.registerTriggersBind('update-product-page',
    function()
    {
      var form = jQuery("ul.attribute-values").closest('form');

      var handler = function ($this)
      {
        xcart.trigger('update-product-page', jQuery('input[name="product_id"]', $this).val());
      };


      jQuery("ul.attribute-values input[type='radio']")
        .unbind('change')
        .bind(
          'change',
          function (e)
          {
            handler(form);
          }
        );
    }
  );

})();

(function() {
  var prev;

  if (typeof(window.OrderItemsList) != 'undefined') {
    prev = OrderItemsList.prototype.handleShowPopover;
    OrderItemsList.prototype.handleShowPopover = function (event) {
      prev.call(this, event);

      jQuery('.popover .attribute-values input[type="radio"]').change(_.bind(this.handlePopoverRadioChange, this));
    };

    OrderItemsList.prototype.handlePopoverRadioChange = function(event)
    {
      var elm = jQuery(event.currentTarget);
      var box = elm.parents('td').eq(0);

      var checked = elm.is(':checked');
      var link = elm.parents('a').eq(0);

      box.find('.av-' + elm.data('attribute-id'))
        .html(link.data('name'));

      box.find('.edit-options-dialog input[name="' + event.currentTarget.name + '"]').each(
        function() {
          var e = jQuery(this);
          var checked = e.val() == elm.val();

          e.prop('checked', checked);
          if (checked) {
            e.parents('a').eq(0).click();
          }
        }
      );

      xcart.trigger('order.itemAttributes.changed', { line: box.parents('tr').eq(0) });
    };

    OrderItemsList.prototype.updateLinePriceLocal = function(line)
    {
      var price = parseFloat(line.data('clear-price'));
      if (isNaN(price)) {
        price = 0;
      }

      line.find('td.name .edit-options-dialog .attribute-values select').each(
        function() {
          var elm = jQuery(this.options[this.selectedIndex]);
          if (elm.data('modifier-price')) {
            var modifier = parseFloat(elm.data('modifier-price'));
            if (!isNaN(modifier) && modifier) {
              price += modifier;
            }
          }
        }
      );

      line.find('td.name fieldset.attribute-values-storage input').each(
        function() {
          var elm = jQuery(this);
          if (elm.data('modifier-price')) {
            var modifier = parseFloat(elm.data('modifier-price'));
            if (!isNaN(modifier) && modifier) {
              price += modifier;
            }
          }
        }
      );

      line.find('td.name .edit-options-dialog .attribute-values :radio:checked').each(
        function() {
          var elm = jQuery(this);
          if (elm.data('modifier-price')) {
            var modifier = parseFloat(elm.data('modifier-price'));
            if (!isNaN(modifier) && modifier) {
              price += modifier;
            }
          }
        }
      );

      this.updateCell(line, {'price': price});
    };

  }
})();
