/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Form fields controller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

CommonForm.elementControllers.push(
  {
    pattern: '.swatch-selector select',
    handler: function ()
    {
      this.updateSwatchBox = function()
      {
        elm        = jQuery(this);
        var e      = elm.get(0);
        var option = jQuery(e.options[e.selectedIndex]);
        var box    = elm.parent().nextAll('.swatch-box');
        var img;

        box.attr('title', option.html());

        if (option.data('color')) {
          box.css('background-color', '#' + option.data('color'));

        } else {
          box.css('background-color', 'transparent');
        }

        if (option.data('image')) {
          if (box.find('img').length > 0) {
            box.find('img').attr('src', option.data('image'));

          } else {
            img = document.createElement('IMG');
            img.src = option.data('image');
            box.append(img);
          }

        } else {
          box.html('');
        }
      };

      jQuery(this).change(
        function(event) {
          xcart.trigger('colorswatches.swatch.change', { target: event.target });
          event.target.updateSwatchBox();
        }
      );

      this.updateSwatchBox();
    }
  }
);
