/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Color field microcontroller
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

CommonForm.elementControllers.push(
  {
    pattern: '.input-field-wrapper input.color',
    handler: function () {
      var options = {
        onShow: function (colpkr) {
          jQuery(this).data('colorpicker-show', true);
          jQuery(this).ColorPickerSetColor(this.value);
          jQuery(colpkr).fadeIn(500);
          jQuery(this).trigger('colorshow', { colpkr: colpkr });

          return false;
        },
        onHide: function (colpkr) {
          var inp = jQuery('.colorpicker').get(0).owner;
          jQuery(this).data('colorpicker-show', false);
          jQuery(colpkr).fadeOut(500);
          jQuery(inp).trigger('colorhide', { colpkr: colpkr });

          return false;
        },
        onSubmit: function(hsb, hex, rgb, el) {
          var inp = jQuery('.colorpicker').get(0).owner;
          jQuery(inp).val(hex)
            .ColorPickerHide();
          jQuery(inp).parents('.inline-field').find('.color-box').css('background-color', '#' + hex);
          jQuery(inp).trigger('colorchange', { hex: hex, rgb: rgb});
        },
        onBeforeShow: function () {
          jQuery('.colorpicker').get(0).owner = this;
          jQuery(this).ColorPickerSetColor(this.value);
          jQuery(this).trigger('colorbeforeshow');
        }
      };

      if (jQuery(this).parents('.create-line').length != 0) {
        jQuery(this).data('colorpickerId', null);
      }

      jQuery(this).ColorPicker(options);
    }
  }
);

