/* vim: set ts=2 sw=2 sts=2 et: */

/**
 * Attributes
 *
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

function ColorSwatchesAttributeController(elm)
{
  Base.apply(this);

  if (elm) {
    this.box = jQuery(elm);
    this.initialize();
  }
}

extend(ColorSwatchesAttributeController, Base);

ColorSwatchesAttributeController.prototype.box = null;

ColorSwatchesAttributeController.prototype.isColorSwatchesModeEnabled = function()
{
  return this.box.find("select[name=displayMode]").val() === 'C';
};

ColorSwatchesAttributeController.prototype.initialize = function()
{
  xcart.bind('attribute.iscolor.changed', _.bind(this.handleAttributeIsColorChange, this));
  xcart.bind('popup.close', _.bind(this.handlePopupClose, this));
  xcart.bind('itemListNewItemCreated', _.bind(this.handleNewItemCreated, this));
  xcart.bind('list.model.table.place', _.bind(this.handleListTablePlace, this));

  this.switchSwatchesVisibility(this.isColorSwatchesModeEnabled());
};

ColorSwatchesAttributeController.prototype.switchSwatchesVisibility = function(visible)
{
  if (typeof visible === "boolean" && visible) {
    this.showSwatches();
  } else {
    this.hideSwatches();
  }
};

ColorSwatchesAttributeController.prototype.showSwatches = function()
{
  this.box.find('.lines td.swatch').show();
  this.box.find('.create td.swatch').show();
};

ColorSwatchesAttributeController.prototype.hideSwatches = function()
{
  this.box.find('.lines td.swatch').hide();
  this.box.find('.create td.swatch').hide();
};

ColorSwatchesAttributeController.prototype.handleAttributeTypeChange = function(event, data)
{
  this.switchVisibility(jQuery(data.target).val() == 'S');
};

ColorSwatchesAttributeController.prototype.handleNewItemCreated = function(event, data)
{
    this.switchSwatchesVisibility(this.isColorSwatchesModeEnabled());
};

ColorSwatchesAttributeController.prototype.handleListTablePlace = function(event, data)
{
    this.switchSwatchesVisibility(this.isColorSwatchesModeEnabled());
};

ColorSwatchesAttributeController.prototype.handlePopupClose = function(event, data)
{
    if (data.box && data.box.find("input#is-color").length > 0 && data.box.is(':ui-dialog')) {
        data.box.find("input#is-color").remove();
    }
};

ColorSwatchesAttributeController.prototype.handleAttributeIsColorChange = function(event, data)
{
  this.switchSwatchesVisibility(this.isColorSwatchesModeEnabled());
};

ColorSwatchesAttributeController.prototype.getEventNamespace = function()
{
  return 'colorswatches.attributes';
};

xcart.bind(
  'afterPopupPlace',
  function(event, data) {
    var elm = jQuery('.ctrl-admin-attribute').last();
     if (elm.length > 0) {
       new ColorSwatchesAttributeController(elm);
     }
  }
);

CommonForm.elementControllers.push({
  pattern: 'select[name=displayMode]',
  handler: function () {
    jQuery(this).change(
      function(event)
      {
        xcart.trigger('attribute.iscolor.changed', {target: event.target});
      }
    );
  }
});
