<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CloudSearch\View\ItemsList;

use QSL\CloudSearch\Model\Repo\Product as ProductRepo;
use XCart\Extender\Mapping\Extender;

/**
 * RequestSearchValuesStorage
 *
 * @Extender\Mixin
 */
class RequestSearchValuesStorage extends \XLite\View\ItemsList\RequestSearchValuesStorage
{
    public const FILTER_PARAM_PREFIX = 'filter_';

    public const ARRAY_VALUES_SEPARATOR = '__';

    /**
     * Get param value
     *
     * @param string $serviceName Search condition service name
     *
     * @return mixed
     */
    public function getValue($serviceName)
    {
        if ($serviceName == ProductRepo::P_CLOUD_FILTERS) {
            return $this->getFilters();
        }

        return parent::getValue($serviceName);
    }

    /**
     * Parse and return
     *
     * @return array
     */
    protected function getFilters()
    {
        $httpParams = $this->parseCGIParams($_SERVER['QUERY_STRING']);

        $filters = [];

        foreach ($httpParams as $key => $v) {
            if (strpos($key, self::FILTER_PARAM_PREFIX) === 0) {
                $filterName = substr($key, strlen(self::FILTER_PARAM_PREFIX));

                $filters[$filterName] = [];

                $values = is_array($v) ? $v : [$v];

                foreach ($values as $value) {
                    $filters[$filterName][] = $value;
                }
            }
        }

        return $filters;
    }

    /**
     * Parse HTTP query string in a *standard* CGI way. PHP uses a different scheme that doesn't allow us to pass arbitrary strings as keys (for example, filter names with spaces in them). Also it will allow duplicate keys for array passing.
     *
     * @param $str
     *
     * @return array
     */
    protected function parseCGIParams($str)
    {
        $arr = [];

        $pairs = explode('&', $str);

        foreach ($pairs as $i) {
            $kv = explode('=', $i, 2);

            if (count($kv) == 2) {
                [$name, $value] = $kv;

                $name  = urldecode($name);
                $value = urldecode($value);
            } else {
                [$name] = $kv;
                $value = null;

                $name = urldecode($name);
            }

            if (isset($arr[$name])) {
                if (is_array($arr[$name])) {
                    $arr[$name][] = $value;
                } else {
                    $arr[$name] = [$arr[$name], $value];
                }
            } else {
                $arr[$name] = $value;
            }
        }

        return $arr;
    }
}
