<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CloudSearch\View\ItemsList\Product\Customer;

use QSL\CloudSearch\Model\Repo\Product as ProductRepo;
use XCart\Extender\Mapping\Extender;
use XLite\Core\CommonCell;
use XLite\Core\Request;

/**
 * Decorated ACustomer items list
 *
 * @Extender\Mixin
 * @Extender\Depend ({"XC\NextPreviousProduct"})
 */
abstract class ACustomerNextPrevious extends \XLite\View\ItemsList\Product\Customer\ACustomer
{
    public const PARAM_CLOUD_FILTERS = 'cloudFilters';

    public const PARAM_LOAD_PRODUCTS_WITH_CLOUD_SEARCH = 'loadProductsWithCloudSearch';

    public const PARAM_VENDOR_ID = 'vendor_id';

    public const PARAM_BRAND_ID = 'brand_id';

    /**
     * @return CommonCell
     */
    protected function getNextPreviousSearchCondition()
    {
        $cnd = parent::getNextPreviousSearchCondition();

        $cnd->{ProductRepo::P_CLOUD_FILTERS} = $this->getSavedRequestParam(self::PARAM_CLOUD_FILTERS);
        if (!empty($cnd->{ProductRepo::P_CLOUD_FILTERS})) {
            $cnd->{ProductRepo::P_LOAD_PRODUCTS_WITH_CLOUD_SEARCH} = true;
        }

        $sessionCell = $this->getSessionCell();
        $page        = '';

        if (strpos($sessionCell, 'XLiteViewItemsListProductCustomerCategoryMain') !== false) {
            $page = 'category';
        } elseif (strpos($sessionCell, 'XLiteModuleXCMultiVendorViewItemsListProductCustomerVendor') !== false) {
            $page = 'vendor';
        } elseif (strpos($sessionCell, 'XLiteModuleQSLShopByBrandViewItemsListProductCustomerBrand') !== false) {
            $page = 'brand';
        }

        if (
            in_array($page, ['category', 'vendor', 'brand'])
            && $this->getSavedRequestParam(self::PARAM_SORT_BY)
            && $this->getSavedRequestParam(self::PARAM_SORT_ORDER)
        ) {
            $cnd->{ProductRepo::P_ORDER_BY} = [
                $this->getSavedRequestParam(self::PARAM_SORT_BY),
                $this->getSavedRequestParam(self::PARAM_SORT_ORDER),
            ];
        }

        if ($page === 'vendor' && $this->getSavedRequestParam(self::PARAM_VENDOR_ID)) {
            $cnd->{ProductRepo::P_VENDOR_ID} = $this->getSavedRequestParam(self::PARAM_VENDOR_ID);
        }

        if ($page === 'brand' && $this->getSavedRequestParam(self::PARAM_BRAND_ID)) {
            Request::getInstance()->__set(self::PARAM_BRAND_ID, $this->getSavedRequestParam(self::PARAM_BRAND_ID));
        }

        return $cnd;
    }
}
