<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CloudSearch\Model;

use XCart\Extender\Mapping\Extender;

/**
 * Product model
 *
 * @Extender\Mixin
 */
class Product extends \XLite\Model\Product
{
    /**
     * Returns meta description in the specified language
     *
     * @param $translation
     *
     * @return string
     */
    public function getTranslatedMetaDesc($translation)
    {
        return $this->getMetaDescType() === static::META_DESC_TYPE_AUTO
            ? static::generateMetaDescription($translation['briefDescription'] ?: $translation['description'])
            : $translation['metaDesc'];
    }
}
