<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CloudSearch\Logic\Import\Step;

use QSL\CloudSearch\Core\IndexingEvent\IndexingEventListener;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class Import extends \XLite\Logic\Import\Step\Import
{
    /**
     * @return void
     */
    public function initialize()
    {
        parent::initialize();

        IndexingEventListener::setImportStarted();
    }

    /**
     * @return void
     */
    public function finalize()
    {
        parent::finalize();

        IndexingEventListener::triggerLatestChangesReindex();
    }
}
