<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CloudSearch\Logic\Import\Console\Step;

use QSL\CloudSearch\Core\IndexingEvent\IndexingEventListener;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class Import extends \XLite\Logic\Import\Console\Step\Import
{
    public function process(): void
    {
        IndexingEventListener::setImportStarted();
        IndexingEventListener::setBatchMode();

        parent::process();

        IndexingEventListener::triggerLatestChangesReindex();
    }
}
