<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CloudSearch\Core;

use QSL\ShopByBrand\Model\Repo\Product;
use XCart\Extender\Mapping\Extender;

/**
 * Produces CloudSearch search parameters from CommonCell conditions
 *
 * @Extender\Mixin
 * @Extender\Depend ({"QSL\ShopByBrand"})
 */
class SearchParametersBrands extends \QSL\CloudSearch\Core\SearchParameters
{
    /**
     * Get search parameters
     *
     * @return array
     */
    public function getParameters()
    {
        $data = parent::getParameters();

        if ($this->cnd->{Product::P_BRAND_ID}) {
            $data['conditions']['brand'] = [$this->cnd->{Product::P_BRAND_ID}];
        }

        return $data;
    }
}
