<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CloudSearch\Core;

use XCart\Extender\Mapping\Extender;

/**
 * Produces CloudSearch search parameters from CommonCell conditions
 *
 * @Extender\Mixin
 * @Extender\Depend({"CDev\Bestsellers"})
 */
class SearchParametersBestsellers extends \QSL\CloudSearch\Core\SearchParameters
{
    /**
     * Get search parameters
     *
     * @return array
     */
    public function getParameters()
    {
        $data = parent::getParameters();

        if ($this->cnd->{'bestsellers'}) {
            $data['conditions']['type'] = ['bestseller'];
        }

        return $data;
    }
}
