<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CloudSearch\Core;

use XLite\Core\Database;

/**
 * CloudSearch registration process scheduler
 */
class RegistrationScheduler extends \XLite\Base\Singleton
{
    /**
     * Scheduled registration flag name
     */
    public const REGISTRATION_SCHEDULED = 'cloud_search_reg_scheduled';

    /**
     * Schedule registration at the first opportunity, but not now
     *
     * @return void
     */
    public function schedule()
    {
        Database::getRepo('XLite\Model\TmpVar')->setVar(static::REGISTRATION_SCHEDULED, true);
    }

    /**
     * Remove registration from schedule
     *
     * @return void
     */
    public function unschedule()
    {
        Database::getRepo('XLite\Model\TmpVar')->setVar(static::REGISTRATION_SCHEDULED, false);
    }

    /**
     * Check if registration was scheduled
     *
     * @return bool
     */
    public function isScheduled()
    {
        return (bool) Database::getRepo('XLite\Model\TmpVar')->getVar(static::REGISTRATION_SCHEDULED);
    }
}
