<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\CloudSearch\Core;

use QSL\CloudSearch\Core\IndexingEvent\IndexingEventListener;
use QSL\CloudSearch\Main;
use XCart\Extender\Mapping\Extender;

/**
 * Database
 *
 * @Extender\Mixin
 */
abstract class DatabaseDecorator extends \XLite\Core\Database
{
    protected static $indexingEventAdded = false;

    /**
     * Start Doctrine entity manager
     *
     * @return void
     */
    public function startEntityManager()
    {
        parent::startEntityManager();

        $this->addIndexingEventListener();
    }

    public function addIndexingEventListener()
    {
        if (!defined('LC_CACHE_BUILDING') && !self::$indexingEventAdded && Main::isRealtimeIndexingEnabled()) {
            static::getEM()->getEventManager()->addEventSubscriber(new IndexingEventListener());
            self::$indexingEventAdded = true;
        }
    }
}
