<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Banner\View\Customer;

use QSL\Banner\Model\Repo\Banner;
use XLite\Core\Auth;
use XLite\Core\Database;
use XLite\Core\Request;

class ABannerSection extends \XLite\View\AView
{
    protected $location = '';

    protected $cnd = null;

    protected $bannerViewListId = null;

    public function __construct(array $params = [])
    {
        if (isset($params['metadata']['entityId'])) {
            // show one banner per list
            $this->bannerViewListId = $params['metadata']['entityId'];
        }

        parent::__construct();
    }

    /**
     * @return array
     */
    public static function getAllowedTargets()
    {
        $result   = parent::getAllowedTargets();
        $result[] = 'main';
        $result[] = 'category';
        $result[] = 'product';
        $result[] = 'page';

        return $result;
    }

    /**
     * @return \XLite\Core\CommonCell
     */
    protected function getBannerBoxesParameters()
    {
        if (is_null($this->cnd)) {
            $this->cnd = new \XLite\Core\CommonCell();

            if ($this->bannerViewListId) {
                $this->cnd->id = $this->bannerViewListId;
            }

            if ($this->location && !$this->bannerViewListId) {
                $this->cnd->location = $this->location;
            }

            $this->cnd->enabled = true;

            if (Auth::getInstance()->getProfile()) {
                $this->cnd->membership_id = Auth::getInstance()->getProfile()->getMembershipId() ?? -1;
            } else {
                $this->cnd->no_membership = true;
                $this->cnd->membership_id = null;
            }

            if ($this->getTarget() === 'main') {
                $this->cnd->homePage = true;
            } elseif ($this->getPage()) {
                $this->cnd->pageId = $this->getPage()->getId();
            } elseif ($this->getCategory()) {
                $this->cnd->categoryId = $this->getCategory();
            } elseif ($this->getProduct()) {
                $this->cnd->categoryId = array_shift($this->getProduct()->getCategories());
            }

            //show on products pages of the selected category
            if (Request::getInstance()->target === 'product') {
                $this->cnd->{Banner::P_PRODUCTS_PAGES} = true;
            }
        }

        return $this->cnd;
    }

    /**
     * @return string
     */
    protected function getBannerBoxes()
    {
        return Database::getRepo(\QSL\Banner\Model\Banner::class)?->getBannerBoxes($this->getBannerBoxesParameters());
    }

    protected function displayDataAttributes($banner)
    {
        return '';
    }

    /**
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/QSL/Banner/banner_section.twig';
    }

    /**
     * @param \QSL\Banner\Model\Banner $banner
     *
     * @return false|string
     */
    protected function getBannerHeight($banner)
    {
        $height = $banner->getHeight();

        if ($height > 0) {
            return 'height: ' . ($height + 2) . 'px;';
        }

        return false;
    }

    /**
     * @param \QSL\Banner\Model\Banner $banner
     *
     * @return false|string
     */
    protected function getBannerLineHeight($banner)
    {
        $height = $banner->getHeight();

        if ($height > 0) {
            return 'line-height: ' . $height . 'px;';
        }

        return false;
    }

    /**
     * @param \QSL\Banner\Model\Banner $banner
     *
     * @return false|string
     */
    protected function getBannerWidth($banner)
    {
        $width = $banner->getWidth();

        if ($width > 0) {
            return 'width: ' . $width . 'px;';
        }

        return false;
    }

    /**
     * @param \QSL\Banner\Model\Banner $banner
     *
     * @return bool
     */
    protected function isParallaxBanner($banner)
    {
        return $banner->getParallax();
    }

    /**
     * @return bool
     */
    protected function isVisible()
    {
        return parent::isVisible() && !$this->isForceChangePassword();
    }

    /**
     * @return bool
     */
    protected function isCacheAvailable()
    {
        return true;
    }

    /**
     * @return integer
     */
    protected function getCacheTTL()
    {
        return 3600;
    }

    /**
     * @return array
     */
    protected function getCacheParameters()
    {
        $list = parent::getCacheParameters();
        $list[] = serialize($this->getBannerBoxesParameters());

        return $list;
    }
}
