<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Banner\View\Button;

class Delete extends \XLite\View\Button\Link
{
    public const BANNER_ID = 'bannerId';

    protected function defineWidgetParams()
    {
        parent::defineWidgetParams();

        $this->widgetParams += [
            self::BANNER_ID => new \XLite\Model\WidgetParam\TypeInt('Banner ID', 1),
        ];
    }

    protected function getBannerContentId()
    {
        return (int) $this->getParam('bannerId');
    }

    protected function getJSCode()
    {
        return 'update_code_' . $this->getBannerContentId() . '.banner_content_id.value=\'' . $this->getBannerContentId() . '\'; update_code_' . $this->getBannerContentId() . '.action.value=\'delete_content\'; update_code_' . $this->getBannerContentId() . '.submit()';
    }
}
