<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\Banner\LifetimeHook;

use QSL\Banner\Model\Banner;
use XLite\Model\ViewList;

final class Enable
{
    public function onEnable(): void
    {
        $toUpdate = [];

        $allBanners = \XLite\Core\Database::getRepo(Banner::class)?->getAllBanners() ?: [];
        foreach ($allBanners as $banner) {
            $viewLists = \XLite\Core\Database::getRepo(ViewList::class)?->findByEntityId($banner->getId()) ?: [];
            if ($viewLists) {
                foreach ($viewLists as $viewList) {
                    if ($viewList->getDeleted()) {
                        $viewList->setDeleted(false);
                        $toUpdate[] = $viewList;
                    }
                }
            }
        }

        if ($toUpdate) {
            \XLite\Core\Database::getRepo(ViewList::class)?->updateInBatch($toUpdate);
        }
    }
}
