<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\View;

/**
 * Widget displaying the "N items of this product will be backordered".
 */
class WillBeBackordered extends \XLite\View\AView
{
    /**
     * Widget parameters
     */
    public const PARAM_IN_STOCK    = 'inStock';
    public const PARAM_BACKORDERED = 'backordered';
    public const PARAM_IS_PREORDER = 'isPreorder';

    /**
     * Define widget parameters.
     *
     * @return void
     */
    protected function defineWidgetParams()
    {
        parent::defineWidgetParams();

        $this->widgetParams += [
            self::PARAM_IN_STOCK    => new \XLite\Model\WidgetParam\TypeInt('Qty in stock', 0, false),
            self::PARAM_BACKORDERED => new \XLite\Model\WidgetParam\TypeInt('Qty backordered', 0, false),
            self::PARAM_IS_PREORDER => new \XLite\Model\WidgetParam\TypeBool('Is preorder', false, false),
        ];
    }

    /**
     * Returns the quantity in stock.
     *
     * @return int
     */
    protected function getQtyInStock()
    {
        return $this->getParam(self::PARAM_IN_STOCK);
    }

    /**
     * Returns the backordered quantity.
     *
     * @return int
     */
    protected function getQtyBackordered()
    {
        return $this->getParam(self::PARAM_BACKORDERED);
    }

    /**
     * Returns the preorder flag
     *
     * @return bool
     */
    protected function isPreorder()
    {
        return $this->getParam(self::PARAM_IS_PREORDER);
    }

    /**
     * Returns the quantity in stock.
     *
     * @return int
     */
    protected function getAvailableType()
    {
        return $this->isPreorder() ? static::t('pre-ordered') : static::t('back-ordered');
    }

    /**
     * Check if the product is out of stock.
     *
     * @return bool
     */
    protected function isOutOfStock()
    {
        return !$this->getQtyInStock();
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/QSL/Backorder/will_be_backordered.twig';
    }
}
