<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\View\Tabs;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Auth;
use XLite\Model\Role\Permission;

/**
 * @Extender\Mixin
 */
abstract class OrdersList extends \XLite\View\Tabs\OrdersList
{
    /**
     * @return string[]
     */
    public static function getAllowedTargets()
    {
        return array_merge(
            parent::getAllowedTargets(),
            [
                'backordered_products'
            ]
        );
    }

    /**
     * @return array
     */
    protected function defineTabs()
    {
        $list = parent::defineTabs();

        if (Auth::getInstance()->isPermissionAllowed(Permission::ROOT_ACCESS)) {
            $list['backordered_products'] = [
                'weight'     => 200,
                'title'      => static::t('Backorders'),
                'url_params' => [
                    'page' => 'orders',
                ],
                'widget'     => 'QSL\Backorder\View\Page\Admin\BackorderedProducts'
            ];
        }

        return $list;
    }

    /**
     * Checks whether the widget is visible, or not
     *
     * @return bool
     */
    protected function isVisible()
    {
        return parent::isVisible() && \XLite\Core\Request::getInstance()->page !== 'products';
    }
}
