<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\View\Tabs;

use XCart\Extender\Mapping\Extender;
use XLite\Core\Auth;

/**
 * @Extender\Mixin
 */
class AllProducts extends \XLite\View\Tabs\AllProducts
{
    /**
     * @return string[]
     */
    public static function getAllowedTargets()
    {
        return array_merge(
            parent::getAllowedTargets(),
            [
                'backordered_products'
            ]
        );
    }

    /**
     * @return array
     */
    protected function defineTabs()
    {
        $list = parent::defineTabs();

        if (Auth::getInstance()->hasRootAccess()) {
            $list['backordered_products'] = [
                'weight'     => 400,
                'title'      => static::t('Backordered'),
                'url_params' => [
                    'page' => 'products',
                ],
                'widget'     => 'QSL\Backorder\View\Page\Admin\BackorderedProducts'
            ];
        }

        return $list;
    }

    /**
     * Checks whether the widget is visible, or not
     *
     * @return bool
     */
    protected function isVisible()
    {
        return parent::isVisible() && \XLite\Core\Request::getInstance()->page !== 'orders';
    }
}
