<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\View\Product;

use XCart\Extender\Mapping\Extender;
use XLite;

/**
 * @Extender\Mixin
 */
abstract class QuantityBox extends \XLite\View\Product\QuantityBox
{
    protected function getAdditionalValidate()
    {
        return $this->getProduct()->isUnlimitedBackorder() ? ''
            : ($this->getProduct()->canBePreordered() ? (',max[' . $this->getMaxQuantity() . ']') : parent::getAdditionalValidate());
    }

    protected function getMaxQuantity()
    {
        $maxQty = $this->getProduct()->canBePreordered() ? 0 : parent::getMaxQuantity();

        return $this->getMaxQtyProducts($maxQty);
    }

    protected function getMaxQtyProducts($maxQty)
    {
        if (is_int($maxQty)) {
            if ($this->getProduct()->isLimitedBackorder()) {
                $maxQty = max($maxQty, 0);

                if ($orderItem = $this->getOrderItem()) {
                    $maxQty = $orderItem->getProductAvailableAmountWithoutBackorder();
                    $add = $orderItem->getProduct()->getBackorderLimit();
                } else {
                    $add = $this->getAvailableBackorderAmount();
                }

                $maxQty += $add;
            } else {
                $maxQty = $this->getProduct()->getMaxPurchaseLimit();

                if (XLite::getController()->getTarget() !== 'cart') {
                    $maxQty -= $this->getProduct()->getItemsInCart();
                }
            }
        }

        return $maxQty;
    }
}
