<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\View\Product;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\After("CDev\ProductAdvisor")
 */
class ListItem extends \XLite\View\Product\ListItem
{
    use \QSL\Backorder\Traits\CanBeBackordered;

    /**
     * @return boolean
     */
    protected function isDisplayAdd2CartButton()
    {
        $result  = parent::isDisplayAdd2CartButton();

        if ($this->getProduct()->canBeBackordered() || $this->getProduct()->canBePreordered()) {
            $result = true;
        }

        return $result;
    }

    /**
     * Get add2cart block widget
     *
     * @return \XLite\View\AView
     */
    protected function getAdd2CartBlockWidget()
    {
        $widget = null;

        $isPreorder = $this->getProduct()->canBePreordered();
        if ($isPreorder || $this->getProduct()->canBeBackordered()) {
            $addLabel = $isPreorder ? 'Pre-order' : 'Add to cart';

            $widget = $this->getWidget(
                [
                'style' => 'add-to-cart product-add2cart productid-' . $this->getProduct()->getProductId(),
                'label'     => $addLabel,
                ],
                'XLite\View\Button\Simple'
            );
        }

        return $widget ?: parent::getAdd2CartBlockWidget();
    }
}
