<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\View\Product\Details\Customer;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\After ("XC\ProductVariants")
 */
abstract class Stock extends \XLite\View\Product\Details\Customer\Stock
{
    protected function getDefaultTemplate()
    {
        return 'modules/QSL/Backorder/product/details/stock/body.twig';
    }

    protected function isOutOfStock() // @kostyl!
    {
        return parent::isOutOfStock() || $this->getAvailableAmount() <= 0;
    }
}
