<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\View\Page\Admin;

use XCart\Extender\Mapping\ListChild;

/**
 * Backordered products page view
 *
 * @ListChild (list="admin.center", zone="admin")
 */
class BackorderSettings extends \XLite\View\AView
{
    /**
     * Return list of allowed targets
     *
     * @return array
     */
    public static function getAllowedTargets()
    {
        return array_merge(parent::getAllowedTargets(), ['backorder_settings']);
    }

    /**
     * Return widget default template
     *
     * @return string
     */
    protected function getDefaultTemplate()
    {
        return 'modules/QSL/Backorder/page/backorder_settings/body.twig';
    }
}
