<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\View\ItemsList\Model;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
abstract class OrderItem extends \XLite\View\ItemsList\Model\OrderItem
{
    protected function removeEntity(\XLite\Model\AEntity $entity)
    {
        $return = parent::removeEntity($entity);

        if (
            $entity->getProduct()->getIsAvailableForBackorder()
            && $this->isNeedUpdateStock()
            && !$entity->isDeleted()
        ) {
            $backorderAmount = $entity->getBackorderAmount() - $entity->getBackorderClosedAmount();

            $entity->changeAmount(- $backorderAmount);

            if ($entity->getProduct()->getIsBackorderLimit()) {
                $entity->getProduct()->changeBackorderLimit($backorderAmount);
            }
        }

        return $return;
    }

    protected function getOrderItemDataFieldValueName($entity)
    {
        if (! $entity instanceof \XLite\Model\OrderItem) {
            return method_exists($entity, 'getName')
                ? $entity->getName()
                : null;
        }

        return $entity->getExtendedItemName();
    }
}
