<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\View\FormModel\Product;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
abstract class Info extends \XLite\View\FormModel\Product\Info
{
    protected function defineFields()
    {
        $schema = parent::defineFields();

        $schema['prices_and_inventory']['isAvailableForBackorder'] = [
            'label'     => static::t('Available for backorder/preorder'),
            'type'      => 'XLite\View\FormModel\Type\SwitcherType',
            'position'  => 500,
        ];

        $schema['prices_and_inventory']['backorderLabel'] = [
            'label'     => static::t('Backorder label'),
            'position'  => 600,
            'help'      => static::t('Help: Backorder label'),
            'show_when' => [
                'prices_and_inventory' => [
                    'isAvailableForBackorder' => '1',
                ],
            ],
        ];

        $schema['prices_and_inventory']['backorder_limit'] = [
            'label'     => static::t('Limit the number of backordered units'),
            'type'      => 'XLite\View\FormModel\Type\Base\CompositeType',
            'fields'    => [
                'isBackorderLimit'  => [
                    'type'      => 'XLite\View\FormModel\Type\SwitcherType',
                    'position'  => 100,
                ],
                'backorderLimit'    => [
                    'label'     => static::t('Backorder limit'),
                    'type'      => 'XLite\View\FormModel\Type\PatternType',
                    'inputmask_pattern'   => [
                        'alias'      => 'integer',
                        'rightAlign' => false,
                    ],
                    'show_when' => [
                        'prices_and_inventory' => [
                            'backorder_limit' => [
                                'isBackorderLimit' => '1',
                            ],
                        ],
                    ],
                    'position'  => 200,
                ],
            ],
            'position'  => 700,
            'show_when' => [
                'prices_and_inventory' => [
                    'isAvailableForBackorder' => '1',
                ],
            ],
        ];

        return $schema;
    }
}
