<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Traits;

/**
 * Helper functions for using in View classes (View/Product/AProduct, View/Product/ListItem)
 */
trait CanBeBackordered
{
    protected function isInStock()
    {
        $return = $this->getProduct()->getInventoryEnabled()
            && !$this->getProduct()->getStockAvailabilityPolicy()->isOutOfStock(\XLite\Model\Cart::getInstance())
            /* essentially \XLite\Model\Product::isOutOfStock */
        ;

        return $return;
    }

    protected function canBeBackordered()
    {
        return $this->getProduct()->canBeBackordered();
    }

    protected function showBackorderLabel()
    {
        $amount = '';
        $return = $this->getProduct()->getBackorderQtyLabel();

        if ($this->getProduct()->isLimitedBackorder()) {
            $amount = $this->getProduct()->getBackorderLimit();
        }

        $return = preg_replace('/%number%/', $amount, $return);

        return $return ?: static::t('Available for backorder message');
    }

    protected function getAvailableBackorderAmount()
    {
        return $this->getProduct()->getAvailableBackorderAmount();
    }

    /**
     * Return 'Out of stock' message
     *
     * @return string
     */
    protected function getOutOfStockMessage()
    {
        return static::t('Out of stock');
    }
}
