<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Module\XC\ProductVariants\View\Product\Details\Customer;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend ("XC\ProductVariants")
 */
abstract class Widget extends \XLite\View\Product\Details\Customer\Widget
{
    /**
     * Check - 'out of stock' label is visible or not
     *
     * @return boolean
     */
    protected function isProductAvailableForSale()
    {
        return $this->getProductVariant()
            ? ($this->getProductVariant()->isAvailable() || $this->getProductVariant()->getAvailableBackorderAmount() > 0)
            : parent::isProductAvailableForSale();
    }
}
