<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Module\XC\ProductVariants\View\Product\Details\Customer;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend ("XC\ProductVariants")
 */
abstract class Stock extends \XLite\View\Product\Details\Customer\Stock
{
    protected function isInStock()
    {
        $result = parent::isInStock();
        $variant = $this->getProductVariant();

        if ($variant) {
            if ($variant->getDefaultAmount()) {
                $result = $this->getProduct()->getInventoryEnabled() && !$variant->isOutOfStockDefault();
            } else {
                $result = !$variant->isOutOfStockDefault();
            }
        } elseif ($this->getProduct()->mustHaveVariants()) {
            $result = false;
        }

        return $result;
    }
}
