<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Module\XC\ProductVariants\View\ItemsList\Model;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend ("XC\ProductVariants")
 */
class BackorderedProducts extends \QSL\Backorder\View\ItemsList\Model\BackorderedProducts
{
    protected function getOrderItems(\QSL\Backorder\Model\BackorderedProduct $product)
    {
        return $product->getVariant()
            ? $product->getVariant()->getOrderItems()
            : parent::getOrderItems($product);
    }

    protected function defineBackorderedProduct($dataArray)
    {
        $return = parent::defineBackorderedProduct($dataArray);

        if ($dataArray['variant_id']) {
            $return->setVariantId($dataArray['variant_id']);
        }

        return $return;
    }
}
