<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Module\XC\ProductVariants\Model\Repo;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend ("XC\ProductVariants")
 */
class OrderItem extends \QSL\Backorder\Model\Repo\OrderItem
{
    /**
     * Prepare top sellers search condition
     *
     * @param \XLite\Core\CommonCell $cnd Conditions
     *
     * @return \Doctrine\ORM\QueryBuilder
     */
    protected function prepareBackordersCondition(\XLite\Core\CommonCell $cnd)
    {
        $query = parent::prepareBackordersCondition($cnd);

        $query->addSelect('IDENTITY(oi.variant) AS variant_id')
            ->addGroupBy('variant_id');

        return $query;
    }
}
