<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Module\XC\ProductVariants\Model\Product;

use XCart\Extender\Mapping\Extender;
use XLite\Model\Cart;

/**
 * @Extender\Mixin
 * @Extender\Depend ({"XC\ProductVariants", "QSL\Backorder"})
 */
abstract class ProductStockAvailabilityPolicy extends \XLite\Model\Product\ProductStockAvailabilityPolicy
{
    public function isVariantOutOfStock(Cart $cart, $variantId)
    {
        return parent::isVariantOutOfStock($cart, $variantId)
            && !$this->dto[static::PRODUCT_IS_AVAILABLE_FOR_BACKORDER];
    }

    public function isVariantOutOfStockDefault(Cart $cart, $variantId)
    {
        return parent::isVariantOutOfStock($cart, $variantId);
    }

    public function isOutOfStockDefault(Cart $cart)
    {
        if (!$this->dto[static::PRODUCT_HAS_VARIANTS]) {
            return parent::isOutOfStock($cart);
        } else {
            foreach ($this->dto[static::PRODUCT_VARIANTS] as $v) {
                if ($v[static::VARIANT_USE_PRODUCTS_AMOUNT]) {
                    if (!parent::isOutOfStock($cart)) {
                        return false;
                    }
                } elseif (!$this->isVariantOutOfStockDefault($cart, $v[static::VARIANT_ID])) {
                    return false;
                }
            }

            return true;
        }
    }
}
