<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Module\XC\ProductVariants\Model;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend ("XC\ProductVariants")
 * @Extender\After ("QSL\Backorder")
 */
abstract class Product extends \XLite\Model\Product
{
    public function canBeBackordered()
    {
        return parent::canBeBackordered()
            && ($this->variants->count() === 0 || $this->getVariantByAttributeValues($this->getAttrValues()));
    }
}
