<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Module\XC\ProductVariants\Model;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend ({"XC\ProductVariants", "QSL\Backorder"})
 */
abstract class OrderItem extends \XLite\Model\OrderItem
{
    /**
     * Returns the public product amount for the item.
     *
     * @return int
     */
    protected function getItemPublicAmount()
    {
        $variant = $this->getVariant();

        return ($variant && !$variant->getDefaultAmount())
            ? $variant->getPublicAmount()
            : parent::getItemPublicAmount();
    }

    /**
     * Check if item is valid.
     *
     * TODO: refactor this dirty hack when #0049295 is solved.
     *
     * The problem there is that ProductVariants module checks variant amounts
     * and fails for variants having zero units in stock. This is wrong for
     * backordered products that may have zero stock. Unfortunately, there is
     * no way to hack into that check added by ProductVariants module.
     * Therefore we have to save the result before the ProductVariants's code,
     * compare it with the later result to determine if it is ProductVariants
     * module that marked the item as invalid, and, if this is the case,
     * replace the result with a new check that doesn't ignore the fact that
     * backordered products may have zero stocks. Plus we have to hope that
     * there are no other modules that hack into this method between the moment
     * when we save the past result, and the moment when we check it.
     *
     * @return boolean
     */
    public function isValid()
    {
        $result = parent::isValid();

        if (!$result && $this->wasValidBeforeProductVariants()) {
            // The check from ProductVariants module starts there...
            $variant = $this->getProduct()->getVariantByAttributeValuesIds($this->getAttributeValuesIds());
            $result = $variant
                && $this->getVariant()
                && $variant->getId() == $this->getVariant()->getId()
                && (
                    !$this->product->getInventoryEnabled()
                    || $this->getVariant()->getDefaultAmount()
                    || 0 < $variant->getAmount()
                    // ...and this is the extra line that we need for backordered items
                    || $this->isAvailableForBackorder()
                );
        }

        return $result;
    }
}
