<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Module\XC\ProductVariants\Model;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend ({"XC\ProductVariants", "QSL\Backorder"})
 */
class Order extends \XLite\Model\Order
{
    /**
     * Check - is item product id equal specified product id
     *
     * @param \XLite\Model\OrderItem $item      Item
     * @param integer                $productId Product id
     *
     * @return boolean
     */
    public function isItemProductIdEqual(\XLite\Model\OrderItem $item, $productId)
    {
        return parent::isItemProductIdEqual($item, $productId)
            && (
                ! $item->getVariant()
                || $item->getVariant()->getDefaultAmount()
                || $item->getProduct()->canBeBackordered()
            );
    }
}
