<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Module\XC\ProductVariants\Model;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend ("XC\ProductVariants")
 */
class BackorderedProduct extends \QSL\Backorder\Model\BackorderedProduct
{
    protected $variant_id = null;

    protected $variant = null;

    public function getVariant()
    {
        if (is_null($this->variant) && !is_null($this->variant_id)) {
            $this->variant = \XLite\Core\Database::getRepo('XC\ProductVariants\Model\ProductVariant')->find($this->variant_id);
        }

        return $this->variant;
    }

    public function getVariantId()
    {
        return $this->variant_id;
    }

    public function setVariantId($value)
    {
        $this->variant_id = $value;
        $this->setType('variant');

        return $this;
    }

    public function isVariantType()
    {
        return $this->getType() === 'variant';
    }

    public function getSku()
    {
        if ($this->isVariantType()) {
            return $this->getVariant()->getDisplaySku();
        }

        return parent::getSku();
    }
}
