<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Module\XC\OrdersImport\Logic\Import\Processor;

use XCart\Extender\Mapping\Extender;
use XLite\Model\OrderItem;

/**
 * @Extender\Mixin
 * @Extender\Depend("XC\OrdersImport")
 */
class Orders extends \XC\OrdersImport\Logic\Import\Processor\Orders
{
    /**
     * Verify 'items' value
     *
     * @param mixed $value  Value
     * @param array $column Column info
     */
    protected function verifyItems($value, array $column)
    {
        parent::verifyItems($value, $column);

        $value = $this->clearEmptyLines($value);

        if (isset($value['itemBackorderAmount'])) {
            foreach ($value['itemBackorderAmount'] as $offset => $val) {
                if (!$this->verifyValueAsUinteger($val)) {
                    $this->addWarning('ORDER-ITEM-BO-QUANTITY-FMT', ['column' => $column, 'value' => $val], $offset);
                }
            }
        }

        if (isset($value['itemBackorderClosedAmount'])) {
            foreach ($value['itemBackorderClosedAmount'] as $offset => $val) {
                if (!$this->verifyValueAsUinteger($val)) {
                    $this->addWarning('ORDER-ITEM-BO-QUANTITY-FMT', ['column' => $column, 'value' => $val], $offset);
                }
            }
        }
    }

    /**
     * Return order item by data
     *
     * @param array $data
     *
     * @return OrderItem
     */
    protected function getItemByData($data)
    {
        $orderItem = parent::getItemByData($data);

        $orderItem->setBackorderAmount($data['itemBackorderAmount'] ?? 0);
        $orderItem->setBackorderClosedAmount($data['itemBackorderClosedAmount'] ?? 0);

        return $orderItem;
    }
}
