<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Model\Repo;

use Doctrine\ORM\Query\Expr\Andx;
use Doctrine\ORM\Query\Expr\Orx;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend ("XC\ProductVariants")
 */
abstract class ProductWithVariants extends \XLite\Model\Repo\Product
{
    protected function prepareCndInventoryIn(\Doctrine\ORM\QueryBuilder $queryBuilder)
    {
        $queryBuilder->linkLeft('p.variants', 'pv');

        $orCnd = new Orx([
            'p.inventoryEnabled = :disabled',
            'pv.amount > :zero',
            new Andx([
                'p.amount > :zero',
                new Orx([
                    'pv.id IS NULL',
                    'pv.defaultAmount = :true'
                ])
            ]),
            'p.isAvailableForBackorder = :true',
        ]);

        $queryBuilder->andWhere($orCnd)
            ->setParameter('disabled', false)
            ->setParameter('zero', 0)
            ->setParameter('true', true);
    }
}
