<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Model\Repo;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend("!CDev\ProductAdvisor")
 */
abstract class ProductAdvisorExclude extends \XLite\Model\Repo\Product
{
    /**
     * @param \Doctrine\ORM\QueryBuilder $queryBuilder
     * @param string                     $alias
     */
    protected function addDateCondition(\Doctrine\ORM\QueryBuilder $queryBuilder, $alias = null)
    {
        if (!\XLite::isAdminZone()) {
            $alias = $alias ?: $queryBuilder->getRootAlias();
            $orCnd = new \Doctrine\ORM\Query\Expr\Orx();
            $orCnd->add($alias . '.arrivalDate < :now');
            $orCnd->add($alias . '.isAvailableForBackorder = :true');

            $queryBuilder->andWhere($orCnd)
                ->setParameter('now', \XLite\Core\Converter::getDayEnd(\XLite\Base\SuperClass::getUserTime()))
                ->setParameter('true', true);
        }
    }
}
