<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Model\Repo;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 * @Extender\Depend ("!XC\ProductVariants")
 */
abstract class Product extends \XLite\Model\Repo\Product
{
    protected function prepareCndInventoryIn(\Doctrine\ORM\QueryBuilder $queryBuilder)
    {
        $orCnd = new \Doctrine\ORM\Query\Expr\Orx();
        $orCnd->add('p.inventoryEnabled = :disabled');
        $orCnd->add('p.amount > :zero');
        $orCnd->add('p.isAvailableForBackorder = :true AND p.isBackorderLimit != :true');
        $orCnd->add('p.isAvailableForBackorder = :true AND p.isBackorderLimit = :true AND p.backorderLimit > :zero');

        $queryBuilder->andWhere($orCnd)
            ->setParameter('disabled', false)
            ->setParameter('zero', 0)
            ->setParameter('true', true);
    }
}
