<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Model\Repo;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class OrderItem extends \XLite\Model\Repo\OrderItem
{
    /**
     * Get top sellers depending on certain condition
     *
     * @param \XLite\Core\CommonCell $cnd Conditions
     * @param boolean $countOnly Count only flag OPTIONAL
     *
     * @return \Doctrine\ORM\PersistentCollection|integer
     */
    public function getBackorders(\XLite\Core\CommonCell $cnd, $countOnly = false)
    {
        $result = $this->prepareBackordersCondition($cnd)->getResult();

        return $countOnly ? count($result) : $result;
    }

    /**
     * Prepare top sellers search condition
     *
     * @param \XLite\Core\CommonCell $cnd Conditions
     *
     * @return \Doctrine\ORM\QueryBuilder
     */
    protected function prepareBackordersCondition(\XLite\Core\CommonCell $cnd)
    {
        $query = \XLite\Core\Database::getRepo('XLite\Model\OrderItem')->createQueryBuilder('oi')
            ->select(
                'IDENTITY(oi.object) AS product_id',
                'SUM(oi.backorderAmount) AS amount'
            )
            ->linkInner('oi.order', 'o')
            ->andWhere('IDENTITY(oi.object) IS NOT NULL')
            ->andWhere('o INSTANCE OF \XLite\Model\Order')
            ->andWhere('o.paymentStatus IS NOT NULL') // don't show products from abandoned carts
            ->andWhere('oi.backorderAmount > 0')
            ->andWhere('oi.backorderAmount > oi.backorderClosedAmount')
            ->groupBy('product_id')
            ->orderBy('amount', 'DESC');

        if ($cnd) {
            $query = $query->orderBy($cnd->orderBy[0], $cnd->orderBy[1]);
        }

        if ($cnd->limit) {
            $this->prepareCndLimit($query, $cnd->limit);
        }

        return $query;
    }
}
