<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Model;

use Doctrine\ORM\Mapping as ORM;
use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class ProductTranslation extends \XLite\Model\ProductTranslation
{
    /**
     * Label that appears next to the stock-level label for out-of-stock products.
     *
     * @var string
     *
     * @ORM\Column (type="string", length=255, nullable=true)
     */
    protected $backorderQtyLabel = '';

    /**
     * Set the label that appears next to the stock-level label for out-of-stock products.
     *
     * @param string $label New label
     *
     * @return ProductTranslation
     */
    public function setBackorderQtyLabel($label)
    {
        $this->backorderQtyLabel = $label;

        return $this;
    }

    /**
     * Returns the label that appears next to the stock-level label for out-of-stock products.
     *
     * @return string
     */
    public function getBackorderQtyLabel()
    {
        return $this->backorderQtyLabel;
    }
}
