<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Model\Order\Status;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
abstract class Shipping extends \XLite\Model\Order\Status\Shipping
{
    public const STATUS_BACK_ORDERED = 'BO';
    public const STATUS_PRE_ORDERED  = 'PO';

    public static function getStatusHandlers()
    {
        $return = array_merge_recursive(
            parent::getStatusHandlers(),
            [
                self::STATUS_BACK_ORDERED => [
                    self::STATUS_NEW                => ['sendBackorder'],
                    self::STATUS_PROCESSING         => ['sendBackorder'],
                    self::STATUS_SHIPPED            => ['sendBackorder', 'ship'],
                    self::STATUS_DELIVERED          => ['sendBackorder'],
                    self::STATUS_WILL_NOT_DELIVER   => ['sendBackorder'],
                    self::STATUS_RETURNED           => ['sendBackorder'],
                ],
                self::STATUS_PRE_ORDERED => [
                    self::STATUS_NEW                => ['sendPreorder'],
                    self::STATUS_PROCESSING         => ['sendPreorder'],
                    self::STATUS_SHIPPED            => ['sendPreorder', 'ship'],
                    self::STATUS_DELIVERED          => ['sendPreorder'],
                    self::STATUS_WILL_NOT_DELIVER   => ['sendPreorder'],
                    self::STATUS_RETURNED           => ['sendPreorder'],
                ],
                self::STATUS_NEW => [
                    self::STATUS_BACK_ORDERED => ['openBackorder'],
                    self::STATUS_PRE_ORDERED  => ['openPreorder'],
                ],
                self::STATUS_PROCESSING => [
                    self::STATUS_BACK_ORDERED => ['openBackorder'],
                    self::STATUS_PRE_ORDERED  => ['openPreorder'],
                ],
                self::STATUS_SHIPPED => [
                    self::STATUS_BACK_ORDERED => ['openBackorder'],
                    self::STATUS_PRE_ORDERED  => ['openPreorder'],
                ],
                self::STATUS_DELIVERED => [
                    self::STATUS_BACK_ORDERED => ['openBackorder'],
                    self::STATUS_PRE_ORDERED  => ['openPreorder'],
                ],
                self::STATUS_WILL_NOT_DELIVER => [
                    self::STATUS_BACK_ORDERED => ['openBackorder'],
                    self::STATUS_PRE_ORDERED  => ['openPreorder'],
                ],
                self::STATUS_RETURNED => [
                    self::STATUS_BACK_ORDERED => ['openBackorder'],
                    self::STATUS_PRE_ORDERED  => ['openPreorder'],
                ],
            ]
        );

        return $return;
    }
}
