<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Model\DTO\Product;

use XCart\Extender\Mapping\Extender;
use XLite\Model\DTO\Base\CommonCell;
use XLite\Model\Product;

/**
 * @Extender\Mixin
 */
abstract class Info extends \XLite\Model\DTO\Product\Info
{
    protected function init($object)
    {
        parent::init($object);

        $this->prices_and_inventory->isAvailableForBackorder = (bool) $object->getIsAvailableForBackorder();
        $this->prices_and_inventory->backorderLabel = $object->getBackorderQtyLabel();
        $this->prices_and_inventory->backorder_limit = new CommonCell([
            'isBackorderLimit'  => (bool) $object->getIsBackorderLimit(),
            'backorderLimit'    => $object->getBackorderLimit(),
        ]);
    }

    /**
     * @param Product    $object
     * @param array|null $rawData
     *
     * @return void
     */
    public function populateTo($object, $rawData = null)
    {
        parent::populateTo($object, $rawData);

        $object->setIsAvailableForBackorder((bool) $this->prices_and_inventory->isAvailableForBackorder);
        $object->setBackorderQtyLabel((string) $this->prices_and_inventory->backorderLabel);
        $object->setIsBackorderLimit((bool) $this->prices_and_inventory->backorder_limit->isBackorderLimit);
        $object->setBackorderLimit((int) $this->prices_and_inventory->backorder_limit->backorderLimit);
    }
}
