<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Model;

use Doctrine\ORM\Mapping as ORM;

/**
 *
 * Fake model to display backordered products as ItemsList.
 * @ORM\Entity
 *
 */
class BackorderedProduct extends \XLite\Model\AEntity
{
    /**
     * Product unique ID
     *
     * @var integer
     *
     * @ORM\Id
     * @ORM\Column         (type="integer", options={ "unsigned": true })
     * @ORM\GeneratedValue (strategy="AUTO")
     */
    protected $b_product_id;

    protected $product_id = null;

    protected $product = null;

    protected $amount = 0;

    protected $type = 'product';

    public function getProduct()
    {
        if (is_null($this->product) && !is_null($this->product_id)) {
            $this->product = \XLite\Core\Database::getRepo('XLite\Model\Product')->find($this->product_id);
        }

        return $this->product;
    }

    public function getSku()
    {
        return $this->getProduct()->getSku();
    }

    public function getProductId()
    {
        return $this->product_id;
    }

    public function setProductId($value)
    {
        $this->product_id = $value;

        return $this;
    }

    public function getAmount()
    {
        return $this->amount;
    }

    public function setAmount($value)
    {
        $this->amount = $value;

        return $this;
    }

    public function getBProductId()
    {
        return $this->b_product_id;
    }

    protected function setType($value)
    {
        $this->type = $value;

        return $this;
    }

    public function getType()
    {
        return $this->type;
    }
}
