<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Logic\Import\Processor;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
abstract class Products extends \XLite\Logic\Import\Processor\Products
{
    protected function defineColumns()
    {
        $columns = parent::defineColumns();

        $columns['availableForBackorder'] = [];
        $columns['backorderLabel'] = [];
        $columns['isBackorderLimited'] = [];
        $columns['backorderLimit'] = [];
        $columns['backorderQtyLabel'] = [
            static::COLUMN_IS_MULTILINGUAL => true,
            static::COLUMN_IS_TAGS_ALLOWED => true,
        ];

        return $columns;
    }

    protected function importAvailableForBackorderColumn(\XLite\Model\Product $model, $value, array $column)
    {
        if ($value) {
            $model->setIsAvailableForBackorder($this->normalizeValueAsBoolean($value));
        }
    }

    protected function importBackorderLabelColumn(\XLite\Model\Product $model, $value, array $column)
    {
        $model->setBackorderQtyLabel($this->normalizeValueAsString($value));
    }

    protected function importIsBackorderLimitedColumn(\XLite\Model\Product $model, $value, array $column)
    {
        if ($value) {
            $model->setIsBackorderLimit($this->normalizeValueAsBoolean($value));
        }
    }

    protected function importBackorderLimitColumn(\XLite\Model\Product $model, $value, array $column)
    {
        if ($value) {
            $model->setBackorderLimit($this->normalizeValueAsUinteger($value));
        }
    }
}
