<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Logic\Export\Step;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
abstract class Products extends \XLite\Logic\Export\Step\Products
{
    /**
     * Define columns
     *
     * @return array
     */
    protected function defineColumns()
    {
        $columns = parent::defineColumns();

        $columns['availableForBackorder'] = [];
        $columns['isBackorderLimited'] = [];
        $columns['backorderLimit'] = [];
        $columns += $this->assignI18nColumns(['backorderQtyLabel' => []]);

        return $columns;
    }

    protected function getAvailableForBackorderColumnValue(array $dataset, $name, $i)
    {
        $result = [];

        $result[] = $this->formatBoolean($dataset['model']->getIsAvailableForBackorder());

        return $result;
    }

    protected function getIsBackorderLimitedColumnValue(array $dataset, $name, $i)
    {
        $result = [];
        $result = $this->formatBoolean($dataset['model']->getIsBackorderLimit());
        return $result;
    }

    protected function getBackorderLimitColumnValue(array $dataset, $name, $i)
    {
        $result = [];
        $result = $dataset['model']->getBackorderLimit();
        return $result;
    }
}
