<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

namespace QSL\Backorder\Logic\Export\Step;

use XCart\Extender\Mapping\Extender;

/**
 * @Extender\Mixin
 */
class Orders extends \XLite\Logic\Export\Step\Orders
{
    /**
     * Define columns
     *
     * @return array
     */
    protected function defineColumns()
    {
        return array_merge(parent::defineColumns(), [
            static::ITEM_PREFIX . 'BackorderAmount'       => [static::COLUMN_MULTIPLE => true],
            static::ITEM_PREFIX . 'BackorderClosedAmount' => [static::COLUMN_MULTIPLE => true],
        ]);
    }

    /**
     * Get column value
     *
     * @param array   $dataset Dataset
     * @param string  $name    Column name
     * @param integer $i       Subcolumn index
     *
     * @return string
     */
    protected function getItemBackorderAmountColumnValue(array $dataset, $name, $i)
    {
        return empty($dataset['item'])
            ? ''
            : $this->getColumnValueByName($dataset['item'], 'backorderAmount');
    }

    /**
     * Get column value
     *
     * @param array   $dataset Dataset
     * @param string  $name    Column name
     * @param integer $i       Subcolumn index
     *
     * @return string
     */
    protected function getItemBackorderClosedAmountColumnValue(array $dataset, $name, $i)
    {
        return empty($dataset['item'])
            ? ''
            : $this->getColumnValueByName($dataset['item'], 'backorderClosedAmount');
    }
}
