<?php

/**
 * Copyright (c) 2011-present Qualiteam software Ltd. All rights reserved.
 * See https://www.x-cart.com/license-agreement.html for license details.
 */

declare(strict_types=1);

namespace QSL\Backorder\Core;

use XCart\Domain\ModuleManagerDomain;
use XCart\Event\Service\ViewListMutationEvent;
use XLite;

final class EventListener
{
    private ModuleManagerDomain $moduleManagerDomain;

    public function __construct(
        ModuleManagerDomain $moduleManagerDomain
    ) {
        $this->moduleManagerDomain = $moduleManagerDomain;
    }

    public function onCollectViewListMutations(ViewListMutationEvent $event): void
    {
        $event->addMutations([
            'items_list/product/parts/common.product-link.twig' => [
                ViewListMutationEvent::TO_REMOVE => [
                    ['itemsList.product.table.customer.columns', XLite::INTERFACE_WEB, XLite::ZONE_CUSTOMER],
                ],
            ],
            'product/details/stock/label.twig'                  => [
                ViewListMutationEvent::TO_REMOVE => [
                    ['itemsList.product.grid.customer.info', XLite::INTERFACE_WEB, XLite::ZONE_CUSTOMER],
                    ['itemsList.product.list.customer.info', XLite::INTERFACE_WEB, XLite::ZONE_CUSTOMER],
                ],
            ],
        ]);
    }

    public function onCollectViewListMutationsAfter(ViewListMutationEvent $event): void
    {
        if ($this->moduleManagerDomain->isEnabled('XC-CrispWhiteSkin')) {
            $notInsertLists = ['itemsList.product.grid.customer.info', 'itemsList.product.list.customer.info'];
            $mutations      = $event->getMutations();

            if (isset($mutations['product/details/stock/label.twig'][ViewListMutationEvent::TO_INSERT])) {
                foreach ($mutations['product/details/stock/label.twig'][ViewListMutationEvent::TO_INSERT] as $k => $mutation) {
                    if (in_array($mutation[0], $notInsertLists, true)) {
                        unset($mutations['product/details/stock/label.twig'][ViewListMutationEvent::TO_INSERT][$k]);
                    }
                }
                if (empty($mutations['product/details/stock/label.twig'][ViewListMutationEvent::TO_INSERT])) {
                    unset($mutations['product/details/stock/label.twig'][ViewListMutationEvent::TO_INSERT]);
                }
                $event->setMutations($mutations);
            }
        }
    }
}
